#ifndef	_ASM_MN10300_VBIOUT_H
#define	_ASM_MN10300_VBIOUT_H

#include <linux/autoconf.h>
#ifndef __ASSEMBLY__
#ifndef RTOS_H_IS_INCLUDED_FROM_SYSTEM_H
#include <asm/unistd.h>
#endif /* RTOS_H_IS_INCLUDED_FROM_SYSTEM_H */
#include <asm/ptrace.h>
#include <linux/types.h>
#include <linux/ioctl.h>
#include <linux/sockios.h>
#include <linux/autoconf.h>
#endif

/* FIXME: VBI register address is not known yet. */
#define VBIREG_BASE		0x5E00C000
#define VBIREG_TXTENB		VBIREG_BASE+0x320
#define VBIREG_TTSDRAMRP	VBIREG_BASE+0x344
#define VBIREG_CC21DATA		VBIREG_BASE+0x318
#define VBIREG_CC284DATA	VBIREG_BASE+0x31C
#define VBIREG_FIELDFLAG	VBIREG_BASE+0x238

#define VBITXT_DATASIZE 48*18
#define VBITXT_BUFSIZE 0x1000
#define VBITXT_BUFNUM 5
#define VBICC_ANYFIELD 2

struct vbiout_ioctl
{
  union
  {
    unsigned int txtenb;
    unsigned char ccdata[3];
    unsigned char text[3];
  } ioctl;
};

#define VBIOUT_IOC_MAGIC		0xD5
#define VBIOUT_SET_TXTENB 		_IO(VBIOUT_IOC_MAGIC, 1)
#define VBIOUT_SET_CC21DATA 		_IO(VBIOUT_IOC_MAGIC, 2)
#define VBIOUT_SET_CC284DATA 		_IO(VBIOUT_IOC_MAGIC, 3)
#define VBIOUT_CHECK_TEXT 		_IO(VBIOUT_IOC_MAGIC, 4)
#define VBIOUT_CHECK_CCDATA 		_IO(VBIOUT_IOC_MAGIC, 5)

#endif /* _ASM_MN10300_VBIOUT_H */
